/* trailer bytes for each of the two Apple GCR formats as follows:	*/

/* Common GCR per-sector header data
/*
/*  Bytes   Description
/*  -----   -----------  
/*    1     Sector Format
/*    3     Header Prolog
/*    4     Header info (vol, trk, sect, cs)
/*    2     Header Epilog (+ 3 bytes static)
/*    3     Data Prolog
/*    1	    Data preload
/*    1     Data Checksum
/*    0     Data Epilog (+ 3 bytes static)
/*  ------
/*   15     total per sector bytes
/*
/* Common GCR per-track header data - note that the trailer length is
/*   NOT part of the calculation for the total bytes per track in that
/*   the trailer count is used to increment memory in the SVD and needs
/*   to increment beyond the trailer length too.
/*
/*    1     trailer type
/*    0     Trailer length
/*  ------
/*    1     total per track bytes
/*
/*  6x2 = 16 sectors * 15 + 1 = (+ (* 16 15) 1) = 241
/*  5x3 = 13 sectors * 15 + 1 = (+ (* 13 15) 1) = 196
/*
/* Trailer bytes
/*
/*  6x2 = (- 256 241) = 15
/*  5x3 = (- 256 196) = 60
********************************/

#define SVD_AGCR6x2_TRAILER_BYTES	15
#define SVD_AGCR5x3_TRAILER_BYTES	60

extern void a2_gcr4x4_map(unsigned char, unsigned char, unsigned char);
extern unsigned char a2_gcr4x4_revmap(unsigned char, unsigned char);

extern unsigned char a2_6x2_gcr_translate(unsigned char *,unsigned char *);
extern int a2_6x2_gcr_revtranslate(unsigned char *,unsigned char *, unsigned char);

extern void rnib_selfsync_process(struct floppy *, int);
